unit UnitSelectDirDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Types,
  Forms,  Dialogs, StdCtrls, ExtCtrls, Grids, DirNavigator01, Buttons,
  CheckLst;

type
  TSelectDirDlg = class(TForm)
    Panel1: TPanel;
    ComboBoxDrive: TComboBox;
    Panel2: TPanel;
    StringGrid1: TStringGrid;
    stxtChoiceDir: TStaticText;
    btnOK: TButton;
    btnCancel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    sbtnRefreshDriveList: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ComboBoxDriveClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure sbtnRefreshDriveListClick(Sender: TObject);
  private
    { Private declarations }
    procedure ChangeDir(Sender: TObject);
  public
    { Public declarations }
  end;

var
  SelectDirDlg: TSelectDirDlg;

implementation

{$R *.dfm}

// ====================================================================
//     
// ====================================================================
var //     ComboBox
    CmbBxDriveList : TComboBoxDriveList;
    //     ListBox
    // LstBxDriveList : TListBoxDriveList;
    DirNavigator  : TDirNavigator;

// --------------------------------------------------------------------
procedure TSelectDirDlg.ChangeDir(Sender: TObject);
begin
   stxtChoiceDir.Caption := (Sender as TDirNavigator).ChoiceDir;
end;

// --------------------------------------------------------------------
procedure TSelectDirDlg.FormCreate(Sender: TObject);
begin
    //     ComboBox
    CmbBxDriveList := TComboBoxDriveList.Create(ComboBoxDrive);
    //     ListBox
    // LstBxDriveList := TListBoxDriveList.Create(ListBox1);
    DirNavigator  := TDirNavigator.Create(StringGrid1);
    DirNavigator.OnChangeDir := ChangeDir;
end;
// --------------------------------------------------------------------
procedure TSelectDirDlg.FormDestroy(Sender: TObject);
begin
   if Assigned(CmbBxDriveList) then CmbBxDriveList.Free;
   // if Assigned(LstBxDriveList) then LstBxDriveList.Free;
   if Assigned(DirNavigator) then DirNavigator.Free;
end;
// --------------------------------------------------------------------
//     ComboBox
procedure TSelectDirDlg.ComboBoxDriveClick(Sender: TObject);
var DriveChar : char;
begin
  if Assigned(CmbBxDriveList) and Assigned(DirNavigator)
  then  begin
     if not ComboBoxDrive.ItemIndex < 0
     then begin
        DriveChar := CmbBxDriveList.DriveChar[ComboBoxDrive.ItemIndex];
        DirNavigator.ChoiceDir := DriveChar + ':'
     end;
  end;
end;
// --------------------------------------------------------------------
//    
procedure TSelectDirDlg.sbtnRefreshDriveListClick(Sender: TObject);
begin
   CmbBxDriveList.Refresh();
end;

// ====================================================================
//
// ====================================================================
procedure TSelectDirDlg.btnCancelClick(Sender: TObject);
begin
   stxtChoiceDir.Caption := '';
   Close;
end;

procedure TSelectDirDlg.btnOKClick(Sender: TObject);
begin
  stxtChoiceDir.Caption := DirNavigator.ChoiceDir;
  Close;
end;




end.
